
# 📰 Multilingual News Platform

A future-ready, AI-assisted multilingual publishing platform designed for North America’s top 10 spoken languages. Built using Next.js 13 App Router, Strapi CMS, GPT-based translation feedback, and Vercel CI/CD.

## 🌍 Supported Languages
- English, Spanish, French, Chinese, Tagalog, Vietnamese, Arabic, Korean, German, Russian, Haitian Creole

## ⚙️ Tech Stack
- Next.js 13 (App Router)
- Strapi CMS
- GPT-4 Translation Review Agent
- DeepL / Google Translate APIs
- Vercel Deployment (CI/CD)
- GitHub Actions

## 🚀 Quick Start

```bash
git clone https://github.com/your-org/your-repo-name.git
cd your-repo-name
cp .env.example .env.local
# Fill in your API keys
npm install
npm run dev
```

## 📁 Project Structure
- `app/[locale]/page.js` – Fetches translated content server-side
- `components/Home.jsx` – Renders multilingual articles with AI tone feedback
- `api/review-translation` – GPT-4 powered review endpoint
- `.github/workflows/deploy.yml` – Auto-deploys to Vercel from main/staging/preview branches

## 🔐 Environment Variables

| Key                     | Description                         |
|------------------------|-------------------------------------|
| `OPENAI_API_KEY`       | API key for GPT-4 agent             |
| `DEEPL_API_KEY`        | (Optional) DeepL translation key    |
| `STRAPI_API_URL`       | URL of the headless CMS             |
| `NEXT_PUBLIC_SITE_URL` | Site root URL for metadata and SEO  |

## 🌐 Vercel Deployment

- Push to `main` → production
- Push to `staging` → preview
- PRs or `preview/**` → Vercel branch previews

## 📣 Editorial Tone Control
Tone is controlled via a field in Strapi (`tone`) and can be:
- `original`, `investigative`, `oped`, `culture`

AI tone-matching will adapt GPT-4 review behavior per tone.

---

MIT License
